param (
	[string]$WinRMCertTemplateName
)
#$WinRMCertTemplateName="SHA256-WinRM"


function set_WinRMHTTPSListener($tp,$cn){
	$selector_set = @{
		Address = "*"
		Transport = "HTTPS"
	}
	$value_set = @{
		CertificateThumbprint = $tp
		Hostname = $cn
	}
	
	New-WSManInstance -ResourceURI "winrm/config/Listener" -SelectorSet $selector_set -ValueSet $value_set
}
# deutsches OS bzw Spracheinstellung
function get_InstalledCertificateInfo($loc) {
	
	$array = gci Cert:\$loc | `
		
		select Thumbprint , `
		
		@{n="CN";e={($_.Subject).split("=")[1]}} , `
		
		@{n="IssuedfromTemplate";e={[regex]::match( ($_.extensions.Format(0) | ? { $_ -match "Vorlage" } ).split(",")[0] , '^(Vorlage\=)(\w.*)(\([0-9.]*(\)))$' ).Groups[2].value}}
	return $array
}
#englsiches OS bzw Spracheinstellung
function get_InstalledCertificateInfo2($loc) {
	
	$array = gci Cert:\$loc | `
		
		select Thumbprint , `
		
		@{n="CN";e={($_.Subject).split("=")[1]}} , `
		
		@{n="IssuedfromTemplate";e={[regex]::match( ($_.extensions.Format(0) | ? { $_ -match "Template" } ).split(",")[0] , '^(Template\=)(\w.*)(\([0-9.]*(\)))$' ).Groups[2].value}}
	return $array
}

function get_WinRMListeners(){
	return (gci -Path WSMan:\localhost\Listener -recurse)
}

function test_WinRMListeners($Wlist,$WPropName,$WlistType){
	return ($Wlist |? {$_.PSChildName -eq $WPropName -and $_.Value -eq $WlistType}).PSParentPath
}

$certLocation = "LocalMachine\My"
$allOK = $false
$WinRMcertFound = $false

do {

	if (get_InstalledCertificateInfo $certLocation | ? {$_.IssuedfromTemplate -eq $WinRMCertTemplateName}){
		$WinRMCorporateCertThumbprint = ((get_InstalledCertificateInfo $certLocation | ? {$_.IssuedfromTemplate -eq $WinRMCertTemplateName}).Thumbprint).replace(" ","").toupper()
		$WinRMCorporateCertCN = (get_InstalledCertificateInfo $certLocation | ? {$_.IssuedfromTemplate -eq $WinRMCertTemplateName}).CN
		write-host "WinRM Certificate ist vorhanden (thumbprint = $WinRMCorporateCertThumbprint)" -ForegroundColor Green
		$WinRMcertFound = $true
	}

else {

	if (get_InstalledCertificateInfo2 $certLocation | ? {$_.IssuedfromTemplate -eq $WinRMCertTemplateName}){
		$WinRMCorporateCertThumbprint = ((get_InstalledCertificateInfo2 $certLocation | ? {$_.IssuedfromTemplate -eq $WinRMCertTemplateName}).Thumbprint).replace(" ","").toupper()
		$WinRMCorporateCertCN = (get_InstalledCertificateInfo2 $certLocation | ? {$_.IssuedfromTemplate -eq $WinRMCertTemplateName}).CN
		write-host "WinRM Certificate ist vorhanden (thumbprint = $WinRMCorporateCertThumbprint)" -ForegroundColor Green
		$WinRMcertFound = $true

    }
	else {
		write-host -ForegroundColor Cyan "Das WinRM Zertifikat wurde noch nicht empfangen. Starte automatisch ein gpupdate."
		write-host -ForegroundColor Magenta "Running GPUPDATE /FORCE..."
		gpupdate /force
	}
	
}} until ($WinRMcertFound -eq $true)

do {
	
	$winRMListeners = get_WinRMListeners
	
	if ($winRMListeners) {
		
		$WinRMHTTPListener_Name = test_WinRMListeners $winRMListeners "Transport" "HTTP"
		if ($WinRMHTTPListener_Name) {
			write-host -ForegroundColor Yellow "Ein WinRM HTTP Listener ist konfiguriert: Entferne..."
			Remove-Item $WinRMHTTPListener_Name -force -recurse
		}
		
		$WinRMHTTPSSLListener_Name = test_WinRMListeners $winRMListeners "Transport" "HTTPS"
		$WinRMHTTPSSLListener_Port = test_WinRMListeners $winRMListeners "Port" "5986"
		if ($WinRMHTTPSSLListener_Name -and $WinRMHTTPSSLListener_Port) {
			
			$WinRMListenerCertThumbprint = ((gci $WinRMHTTPSSLListener_Name\CertificateThumbprint).value).replace(" ","").toupper()
			
			if ($WinRMListenerCertThumbprint -ne $WinRMCorporateCertThumbprint) {
				write-host -ForegroundColor Yellow "Ein WinRM HTTPS Listener wurde gefunden, aber ohne Zertifikatsbindung: Entferne..."
				remove-item $WinRMHTTPSSLListener_Name -force -recurse
				$allOK = $false
			}
			else {
				write-host -ForegroundColor Green "Der WinRM Listener ist konfiguriert (Certificate + HTTPS Listener)"
				$allOK = $true
			}
		}
		else {
			
			$process = 'cmd.exe'
			$arguments = '/c winrm invoke restore winrm/config @{}'
			start-process $process -ArgumentList $arguments -Wait
			$allOK = $false
		}
	}
	
	if ($allOK -eq $false){
		
		set_WinRMHTTPSListener $WinRMCorporateCertThumbprint $WinRMCorporateCertCN
		get_WinRMListeners |? {$_.PSChildName -eq "Transport" -and $_.Value -eq "HTTPS"}
	}
} until ($allOK -eq $true)