﻿# Neue Schlüssel erstellen
New-Item -Path "HKCU:\Software\Temp"
New-ItemProperty -path "HKCU:\Software\Temp" -name DERWINDOWSPAPST -PropertyType DWORD -value 1

New-Item -Path "HKCU:\Software\Temp"
New-ItemProperty -path "HKCU:\Software\Temp" -name DERWINDOWSPAPST1 -PropertyType String -value "1" 

New-Item -Path "HKCU:\Software\Temp"
New-ItemProperty -path "HKCU:\Software\Temp" -name DERWINDOWSPAPST2 -PropertyType MultiString -value "Der-Windows-Papst","1","2"

# Einen Wert ändern
Set-ItemProperty -Path "HKCU:\Software\Temp" DERWINDOWSPAPST1 -Value 2 –Force
Get-ItemProperty -Path "HKCU:\Software\Temp" DERWINDOWSPAPST1 | %{set-itemproperty -Path $_.PSPath DERWINDOWSPAPST1 -Value ( $_.DERWINDOWSPAPST1 -Replace "1", "2" )} 

# Einen weiteren Eintrag hinzufügen
Set-ItemProperty -Path "HKCU:\Software\Temp" DERWINDOWSPAPST3 -Value 3 –Force 

# Ist ein Eintrag namens DERWINDOWSPAPST3 vorhanden
Get-ItemProperty -Path Registry::HKEY_CURRENT_USER\Software\Temp
Get-Item -Path Registry::HKEY_CURRENT_USER\Software\Temp\ | Select-Object -ExpandProperty Property
Get-ChildItem HKCU:\Software | Format-List 
Test-Path "HKCU:\Software\Temp"
Test-Path "HKCU:\Software\Temp\DERWINDOWSPAPST3"

# Welche Schlüssel sind unterhalb von HKCU:\Software\Temp vorhanden
Get-ChildItem -Path HKCU:\Software\Temp -Recurse

# Einen Wert prüfen/anzeigen
Get-ItemProperty -Path "HKCU:\Software\Temp" | select DERWINDOWSPAPST2

# Einen Eintrag umbenennen
Rename-ItemProperty -Path HKCU:\Software\Temp -Name DERWINDOWSPAPST3 -NewName DERWINDOWSPAPST4

# Einen Eintrag löschen
Remove-ItemProperty -Path HKCU:\Software\Temp -Name DERWINDOWSPAPST4

# Einen Schlüssel löschen
Remove-Item -Path HKCU:\Software\Temp

# Einen Schlüssel kopieren
Copy-Item -path Registry::HKEY_CURRENT_USER\Software\Temp -destination Registry::HKEY_CURRENT_USER\Software\Wow6432Node

# Einen Schlüssel verschieben:
Move-Item -path Registry::HKEY_CURRENT_USER\Software\Temp -destination Registry::HKEY_CURRENT_USER\Software\Wow6432Node

# vorhandenen Wert ändern
$regPath = "HKCU:\Software\Temp"
$Name = "DerWindowsPapst"
$value = "3"

IF(!(Test-Path $regPath))

  {

    New-Item -Path $regPath -Force | Out-Null

    New-ItemProperty -Path $regPath -Name $name -Value $value -PropertyType DWORD -Force | Out-Null}

 ELSE {

    New-ItemProperty -Path $regPath -Name $name -Value $value -PropertyType DWORD -Force | Out-Null}

(Get-Item -Path "HKCU:\Software\Temp" -Name DerWindowsPapst).DerWindowsPapst


# Ist System 64 oder 32 Bit
$RegLoc = @("HKLM:\Software\Temp")

if([System.Environment]::Is64BitProcess){
    $RegLoc += "HKLM:\SOFTWARE\Wow6432Node\Temp"
}

foreach($Key in $RegLoc)
{
    if(-not(Test-Path $Key)){
        New-Item -Path $Key -Force
    }
    New-ItemProperty -Path $Key -Name "DerWindowsPapst" -Value 1 -ErrorAction SilentlyContinue -PropertyType DWord 
}