'* script Jrn Walter 2017 https://www.der-windows-papst.de

Dim objSysInfo, objUser
Set objSysInfo = CreateObject("ADSystemInfo")
Set objUser = GetObject("LDAP://" & objSysInfo.UserName)
Set objComputer = GetObject("LDAP://" & objSysInfo.ComputerName)
Dim sSiteName : sSiteName = objSysInfo.SiteName
If Err Then
	sSiteName = "Unknown"
	Err.Clear
End If

If WScript.Arguments.length =0 Then
  Set objShell = CreateObject("Shell.Application")
  objShell.ShellExecute "wscript.exe", Chr(34) & _
  WScript.ScriptFullName & Chr(34) & " uac", "", "runas", 1
Else

'* Deklarationen
Set MyFiles = CreateObject("Scripting.FileSystemObject")
Set wshNetwork = WScript.CreateObject( "WScript.Network" )
Set WshShell = WScript.CreateObject("WScript.Shell")
Set WSHEnvOS = WSHShell.Environment("Process")
Set WSHEnvPrg = WSHShell.Environment("Process")
Company = "Windows Papst Hardware Inventur luft..."

'* Ermitteln des Usernamens, Computernamens un der Anmeldedomne
Do While wshNetwork.username = ""
WScript.Sleep 250
Loop
strComputerName = wshNetwork.computerName
strUserName = wshNetwork.userName
strDomainName = wshNetwork.userDomain

WshShell.Run "%comspec% /c if not exist \\dc01\netlogon\inventur\. md \\dc01\netlogon\inventur\",0,True

If Not MyFiles.FileExists("\\dc01\netlogon\inventur\" & strComputerName & ".log") Then MyFiles.CreateTextFile("\\dc01\netlogon\inventur\"& strComputerName & ".log")
Set logfile = MyFiles.OpenTextFile("\\dc01\netlogon\inventur\" & strComputerName & ".log",8)

'------------------------------------------------------ RAM und Prozessor
Set objWMIService = GetObject("winmgmts:\\" & strComputerName & "\root\cimv2")
Set colItems = objWMIService.ExecQuery("Select * from Win32_Processor",,48)
For Each objItem In colItems
strProzessor = objItem.Name & ": " & objItem.CurrentClockSpeed & " Mhz"
Next

Set objWMIService = GetObject("winmgmts:\\" & strComputerName & "\root\cimv2")
Set colItems = objWMIService.ExecQuery("Select * from Win32_ComputerSystem",,48)
For Each objItem In colItems
strspeicher= "Gesamtspeicher (MB): " & objItem.TotalPhysicalMemory /1000
Next
'------------------------------------------------------ RAM und Prozessor

'------------------------------------------------------ Office
Function GetOfficeVer()

sRegPre = "HKLM\SOFTWARE\Microsoft\Office\"
sRegPost = "\Common\InstallRoot\"
Select Case True
Case RegKeyExists(sRegPre & "16.0" & sRegPost)
sOfficeVer = "2016"
Case RegKeyExists(sRegPre & "15.0" & sRegPost)
sOfficeVer = "2013"
Case RegKeyExists(sRegPre & "14.0" & sRegPost)
sOfficeVer = "2010"
Case RegKeyExists(sRegPre & "12.0" & sRegPost)
sOfficeVer = "2007"
Case RegKeyExists(sRegPre & "11.0" & sRegPost)
sOfficeVer = "2003"
Case RegKeyExists(sRegPre & "10.0" & sRegPost)
sOfficeVer = "2002"
Case RegKeyExists(sRegPre & "9.0" & sRegPost)
sOfficeVer = "2000"
Case Else
sOfficeVer = "Keine"
End Select
GetOfficeVer = sOfficeVer
End Function

Function RegKeyExists(ByVal sRegKey)

Dim sDescription, oShell
Set oShell = CreateObject("WScript.Shell")

RegKeyExists = True
sRegKey = Trim (sRegKey)
If Not Right(sRegKey, 1) = "\" Then
sRegKey = sRegKey & "\"
End If

On Error Resume Next
oShell.RegRead "HKEYNotAKey\"
sDescription = Replace(Err.Description, "HKEYNotAKey\", "")

Err.Clear
oShell.RegRead sRegKey
RegKeyExists = sDescription <> Replace(Err.Description, sRegKey, "")
On Error Goto 0
End Function

'------------------------------------------------------ Office

'------------------------------------------------------ Win

Set colOSes = objWMIService.ExecQuery("Select * from Win32_OperatingSystem") 
For each objOS in colOSes
GetOS = objOS.caption
archi = objOS.OSArchitecture
Next

'------------------------------------------------------ Win

'------------------------------------------------------ Model SN

Set objWMIService = GetObject("winmgmts:\\" & strComputername & "\root\cimv2")
Set colItems = objWMIService.ExecQuery("Select * from Win32_ComputerSystemProduct",,48)
For Each objItem In colItems
modell=objItem.Vendor & " " & objItem.Name
serial="Seriennummer: " & objItem.IdentifyingNumber
Next

'------------------------------------------------------ Model SN

'* Aufruf der Subroutine
Call SubZusammenfassung

'* Die Routine
Sub SubZusammenfassung ()
'* Bentigte Deklarationen
Set colDrives = wshNetwork.EnumNetworkDrives
Dim CRLF
CRLF = Chr(13) & Chr(10)
strMsg = CRLF & "Anmelde Ergebnisse vom: " & cRLF & "Datum " & Date & "  Uhrzeit " & Time & "" & CRLF & CRLF & "Benutzername" & Chr(9) & "= " & strUserName & CRLF & "Computername" & Chr(9) & "= " & strComputerName & CRLF & "Domne" & Chr(9) & Chr (9) & "= " & strDomainName & CRLF & CRLF & modell & CRLF & serial & CRLF & CRLF & strProzessor & CRLF & strspeicher & CRLF & "Office Version: " & GetOfficeVer & CRLF & "" & GetOs & " = " & archi & CRLF

'* Verbundene Netzlaufwerke listen
If colDrives.Count = 0 Then
strMsg = strMsg & CRLF & "Kein Netzlaufwerk ist verbunden." & CRLF
Else
strMsg = strMsg & CRLF & "Verbundene Netzlaufwerk(e):" & CRLF
For i = 0 To colDrives.Count - 1 Step 2
strMsg = strMsg & CRLF & colDrives(i) & Chr(9) & colDrives(i + 1)
Next
End If

'* LOG
logfile.write(strMsg) & CRLF
'logfile.writeline "################## Script von Jrn Walter v1.0 2017 ##################"

strMessage = objUser.displayName & " - Logon: " & Date & " - " & Left(Time,5) & " / " & modell & " / " & Serial & " / " & GetOS & " - " & archi
'objComputer.ExtensionAttribute10 = strMessage
objComputer.Description = strMessage
objComputer.SetInfo

End Sub
End If