﻿$Host.UI.RawUI.WindowTitle = "Windows Powershell" + $Host.Version

Write-Host -ForegroundColor Cyan       "_______       _____________          "
Write-Host -ForegroundColor Cyan       "_______       _____________          "
Write-Host -ForegroundColor Cyan       "___    |___  _______  /__(_)___  __  "
Write-Host -ForegroundColor Cyan       "__  /| |  / / /  __  /__  /__  |/_/  "
Write-Host -ForegroundColor Cyan       "_  ___ / /_/ // /_/ / _  / __>  <    "
Write-Host -ForegroundColor Cyan       "/_/  |_\__,_/ \__,_/  /_/  /_/|_|    "
Write-Host -ForegroundColor DarkCyan   "@Littl3field                         "
Write-Host -ForegroundColor DarkCyan   "angepasst an das deutsche OS durch   "
Write-Host -ForegroundColor DarkCyan   "https://www.der-windows-papst.de     "

#------------------------------------------------------------------------
# Check script is running as admin
#------------------------------------------------------------------------

function ValAdmin
{
    [CmdletBinding()]
    param (
    )

    # Check against the generic administrator role (language neutral).
    $AdministratorRole = [Security.Principal.WindowsBuiltInRole]::Administrator

    # Get the current user identity
    $CurrentWindowsPrincipal = [Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()

    # Output error if script not ran with administrator role
    if ($CurrentWindowsPrincipal.IsInRole($AdministratorRole) -eq $false)
    { 
    Write-Host -ForegroundColor Cyan "`n [ERROR] Du bist KEIN lokaler Administrator.  Starte das Skript noch einmal nach dem du dich als Administartor eingeloggt hast."
    }

    # Output success if script ran with administrator role
    if ($CurrentWindowsPrincipal.IsInRole($AdministratorRole) -eq $true) 
    {
    Write-Host -ForegroundColor Cyan "`n [SUCCESS] Das Skript laeuft mit administrativen Rechten."
    }

    # Return value
    return $CurrentWindowsPrincipal.IsInRole($AdministratorRole)

}
$IsValAdmin = ValAdmin
Start-Sleep -Seconds 2

#------------------------------------------------------------------------
# List All Auditpol Categories as CSV
#------------------------------------------------------------------------

function ListCategoryAllCsv
{
    [CmdletBinding()]
    param ()

    (auditpol.exe /get /category:* /r) |
        Where-Object { -not [String]::IsNullOrEmpty($_) }
}

#------------------------------------------------------------------------
# List All Auditpol Subcategories as CSV
#------------------------------------------------------------------------

function ListSubcategoryAllCsv
{
    [CmdletBinding()]
    param ()

    (auditpol.exe /list /subcategory:* /r) |
        Where-Object { -not [String]::IsNullOrEmpty($_) }
}

#------------------------------------------------------------------------
# Get Current Audit Policy
#------------------------------------------------------------------------

function GetAuditPol
{
    [CmdletBinding()]
    param (
    )

    # User helper function to execute auditpol queries
    $csvAuditCategories = ListSubcategoryAllCsv | ConvertFrom-Csv
    $csvAuditSettings   = ListCategoryAllCsv | ConvertFrom-Csv

    foreach ($csvAuditCategory in $csvAuditCategories)
    {
        # If the Category/Subcategory field starts with two blanks, it is a
        # subcategory entry - else a category entry.
        if ($csvAuditCategory.'GUID' -like '{*-797A-11D9-BED3-505054503030}')
        {
            $lastCategory     = $csvAuditCategory.'Category/Subcategory'
            $lastCategoryGuid = $csvAuditCategory.GUID
        }
        else
        {
            $csvAuditSetting = $csvAuditSettings | Where-Object { $_.'Subcategory GUID' -eq $csvAuditCategory.GUID }

            $auditPolicy = New-Object -TypeName PSObject -Property @{
                ComputerName    = $csvAuditSetting.'Machine Name'
                Category        = $lastCategory
                CategoryGuid    = $lastCategoryGuid
                Subcategory     = $csvAuditSetting.'Subcategory'
                SubcategoryGuid = $csvAuditSetting.'Subcategory GUID'
                AuditSuccess    = $csvAuditSetting.'Inclusion Setting' -like '*Success*'
                AuditFailure    = $csvAuditSetting.'Inclusion Setting' -like '*Failure*'
            }

            $auditPolicy.PSTypeNames.Insert(0, 'SecurityFever.AuditPolicy')

            Write-Output $auditPolicy
        }
    }
}
$CurrentAuditPol = GetAuditPol
#Write-Output $CurrentAuditPol

#------------------------------------------------------------------------
# Define export filepath for audit policy
#------------------------------------------------------------------------

function ExportFilePath {
        [CmdletBinding()]
        param (
        [Parameter(Mandatory=$True,ValueFromPipeline, HelpMessage = 'Bitte gebe einen gueltigen Pfad an C:\Users\admin\Desktop')]
        [string]$SetExportFilepath
        )

        $validate = Test-Path $SetExportFilePath
        Start-Sleep -Seconds 0.5
        If ($validate -eq $true) {     
            Write-Host -ForegroundColor Cyan "`n[SUCCESS] $SetExportFilepath ist ein valider Pfad."
            Start-Sleep -Seconds 0.5
            $a = $CurrentAuditPol
            $filename = "AudixOutput.txt"
            $a | Out-File -FilePath $SetExportFilepath'\AudixOutput.txt'
            Start-Sleep -Seconds 0.5
            Write-Host -ForegroundColor Cyan "[SUCCESS] Die Audit-Richtlinien sind exportiert worden nach $SetExportFilepath $filename"
            }
               
        else
        {Write-Host -ForegroundColor Cyan "[ERROR] $SetExportFilepath ist nicht valide, bitte einen validen Pfad angeben. Beispiel: C:\Users\admin\Desktop"}
        return $ExportAudixFilepath
        }

#------------------------------------------------------------------------
# Ask user if they would like to export the current Audit Policy
#------------------------------------------------------------------------

Write-Host -ForegroundColor Cyan "`n[INFO] Willst Du die aktuellen Audit-Richtlinien exportieren? (j/n)"
$confirmation = Read-Host 
Start-Sleep -Seconds 1
if ($confirmation -eq 'j') {
    Write-Host -ForegroundColor Cyan "[INFO] Bitte gib fuer den Export einen gueltigen Pfad an. Beispiel C:\Users\admin\Desktop"
    ExportFilePath}
    else {Write-Host -ForegroundColor Cyan "[INFO] Die aktuellen Audit-Richtlinien konnten nicht exportiert werden."
            }

#------------------------------------------------------------------------
# Perform backup of current Audit Policy
#------------------------------------------------------------------------

function BackupFilepath
{
    [CmdletBinding()]
    param (
    [Parameter(Mandatory=$True,ValueFromPipeline, HelpMessage = 'Du musst einen gueltigen Pfad angeben, wenn die Sicherung erstellt werden soll. Example C:\Users\admin\Desktop')]
    [string]$SetBackupFilePath
        )

    $validatebackup = Test-Path $SetBackupFilePath
    Start-Sleep -Seconds 0.5
    If ($validatebackup -eq $true) {
    Write-Host -ForegroundColor Cyan "`n[SUCCESS] $SetBackupFilePath ist ein valider Pfad."
    Start-Sleep -Seconds 0.5
    $Backupfilename = "\AuditpolBackup.csv"
    $Join = $SetBackupFilePath + $Backupfilename
    Start-Sleep -Seconds 0.5
    (auditpol.exe /backup /file:$join) |
        Where-Object { -not [String]::IsNullOrEmpty($_) }
        Write-Host -ForegroundColor Cyan "`n[SUCCESS] Audit-Richtlinien Backup ist abgeschlossen."
    }

    else
        {Write-Host -ForegroundColor Cyan "[ERROR] $filepath ist nicht valide. Bitte gebe einen gueltigen Pfad an. Example: C:\Users\admin\Desktop"}
    
    return $ExportAudixFilepath
    }

#------------------------------------------------------------------------
# Ask user if they would like to perform an Audit Policy backup
#------------------------------------------------------------------------

Write-Host -ForegroundColor Cyan "`n[INFO] Moechtest Du eine Sicherung der aktuellen Audit-Richtlinien erstellen? (j/n)"
$confirmation = Read-Host 
if ($confirmation -eq 'j') {
    Start-Sleep -Seconds 0.5
    Write-Host -ForegroundColor Cyan "[INFO] Bitte gib einen validen Pfad an. Beispiel C:\Users\admin\Desktop"
    Backupfilepath
}
    else {Write-Host -ForegroundColor Cyan "[INFO] Die aktuellen Audit-Richtlininen konnten NICHT gesichert werden."
            }

#------------------------------------------------------------------------
# Perform Audit Policy Change
# Credit: @cyb3rops
#------------------------------------------------------------------------

$argumentList= @(
'"Sicherheitsstatusänderung" /success:enable /failure:enable'
'"Sicherheitssystemerweiterung" /success:enable /failure:enable'
'"Systemintegrität" /success:enable /failure:enable'
'"IPSEC-Treiber" /success:disable /failure:disable'
'"Andere Systemereignisse" /success:disable /failure:enable'
'"Anmelden" /success:enable /failure:enable'
'"Abmelden" /success:enable /failure:enable'
'"Kontosperrung" /success:enable /failure:enable'
'"IPsec-Hauptmodus" /success:disable /failure:disable'
'"IPsec-Schnellmodus" /success:disable /failure:disable'
'"IPsec-Erweiterungsmodus" /success:disable /failure:disable'
'"Spezielle Anmeldung" /success:enable /failure:enable'
'"Andere Anmelde-/Abmeldeereignisse" /success:enable /failure:enable'
'"Netzwerkrichtlinienserver" /success:enable /failure:enable'
'"Dateisystem" /success:enable /failure:enable'
'"Registrierung" /success:enable /failure:enable'
'"Kernelobjekt" /success:enable /failure:enable'
'"SAM" /success:disable /failure:disable'
'"Zertifizierungsdienste" /success:enable /failure:enable'
'"Anwendung wurde generiert." /success:enable /failure:enable'
'"Handleänderung" /success:disable /failure:disable'
'"Dateifreigabe" /success:enable /failure:enable'
'"Filterplattform: Verworfene Pakete" /success:disable /failure:disable'
'"Filterplattformverbindung" /success:disable /failure:disable'
'"Andere Objektzugriffsereignisse" /success:disable /failure:disable'
'"Sensible Verwendung von Rechten" /success:disable /failure:disable'
'"Nicht sensible Verwendung von Rechten" /success:disable /failure:disable'
'"Andere Rechteverwendungsereignisse" /success:disable /failure:disable'
'"Prozesserstellung" /success:enable /failure:enable'
'"Prozessbeendigung" /success:enable /failure:enable'
'"DPAPI-Aktivität" /success:disable /failure:disable'
'"RPC-Ereignisse" /success:enable /failure:enable'
'"Richtlinienänderungen überwachen" /success:enable /failure:enable'
'"Autorisierungsrichtlinienänderung" /success:enable /failure:enable'
'"Authentifizierungsrichtlinienänderung" /success:enable /failure:enable'
'"MPSSVC-Richtlinienänderung auf Regelebene" /success:disable /failure:disable'
'"Filterplattform-Richtlinienänderung" /success:disable /failure:disable'
'"Andere Richtlinienänderungsereignisse" /success:disable /failure:enable'
'"Benutzerkontenverwaltung" /success:enable /failure:enable'
'"Computerkontoverwaltung" /success:enable /failure:enable'
'"Sicherheitsgruppenverwaltung" /success:enable /failure:enable'
'"Verteilergruppenverwaltung" /success:enable /failure:enable'
'"Anwendungsgruppenverwaltung" /success:enable /failure:enable'
'"Andere Kontoverwaltungsereignisse" /success:enable /failure:enable'
'"Verzeichnisdienstzugriff" /success:enable /failure:enable'
'"Verzeichnisdienständerungen" /success:enable /failure:enable'
'"Verzeichnisdienstreplikation" /success:disable /failure:disable'
'"Detaillierte Verzeichnisdienstreplikation" /success:disable /failure:disable'
'"Überprüfung der Anmeldeinformationen" /success:enable /failure:enable'
'"Ticketvorgänge des Kerberos-Diensts" /success:enable /failure:enable'
'"Andere Kontoanmeldungsereignisse" /success:enable /failure:enable'
'"Kerberos-Authentifizierungsdienst" /success:enable /failure:enable'
)

function RunAuditPolicyChange
{
    [CmdletBinding()]
    param (
        )
    
    foreach ($policy in $argumentList) {
        Start-Sleep -Seconds 0.5
        $command = "auditpol.exe /set /subcategory:"
        $join = $command + $policy
        (iex $join) |
        Where-Object { -not [String]::IsNullOrEmpty($_) }

        }
    }

#------------------------------------------------------------------------
# Force Advance Audit Policy by applying SCENoApply Regkey
#------------------------------------------------------------------------

function AddSCNoApplyLegacy
{
    [CmdletBinding()]
    param (
        )
    Start-Sleep -Seconds 2
    $LSARegistryPath = "HKLM:\SYSTEM\CurrentControlSet\Control\Lsa"
    $Name = "Version"
    $value = "1"
    $SCENoApply = "SCENoApplyLegacyAuditPolicy"
    $REG_DWORD = "DWORD"

    New-ItemProperty -Path $LSARegistryPath -Name $SCENoApply -Value $value -PropertyType $REG_DWORD -ErrorAction SilentlyContinue

    }

#------------------------------------------------------------------------
# Add ProcessCreationtoIncludeCmdLine_Enabled
#------------------------------------------------------------------------

function ProcessCreationCmd
{
    [CmdletBinding()]
    param (
        )
    Start-Sleep -Seconds 2
    $AuditRegistryPath = "HKLM:\software\microsoft\windows\currentversion\policies\system\audit"
    $Name = "Version"
    $value = "1"
    $ProcessCreation = "ProcessCreationIncludeCmdLine_Enabled"
    $REG_DWORD = "DWORD"

    New-ItemProperty -Path $AuditRegistryPath -Name $ProcessCreation -Value $value -PropertyType $REG_DWORD -ErrorAction SilentlyContinue

    }


#------------------------------------------------------------------------
# Ask user if they would like to perform the audit policy change
#------------------------------------------------------------------------

Write-Host -ForegroundColor Cyan "`n[INFO] Moechtest Du nun die empfohlenen Audit-Richtlinien-Einstellungen setzen? (j/n)"
$confirmation = Read-Host 
if ($confirmation -eq 'j') {
    Write-Host -ForegroundColor Cyan "[INFO] Starte die Umsetzung der Empfehlung"
    Start-Sleep -Seconds 0.1
    RunAuditPolicyChange
    Write-Host -ForegroundColor Cyan "`n[INFO] Erzwinge die Einstellung der erweiterten Ueberwachungsrichtlinien"
    AddSCNoApplyLegacy
    Write-Host -ForegroundColor Cyan "`n[INFO] Erzwingen der Prozessbefehlszeileneinstellung"
    ProcessCreationCmd
}
    else {Write-Host -ForegroundColor Cyan "[INFO] Die aktuellen Audit-Richtlinien wurden NICHT veraendert"
            }

#------------------------------------------------------------------------
# Set Security log retention to 7 days 
#------------------------------------------------------------------------

function SecurityEventLoggingSize
{
    [CmdletBinding()]
    param (
        )
    Start-Sleep -Seconds 1
    Limit-EventLog -LogName Security -OverflowAction OverwriteOlder -RetentionDays 7

    }

#------------------------------------------------------------------------
# Ask user for logging size limit
#------------------------------------------------------------------------

Write-Host -ForegroundColor Cyan "`n[INFO] Soll die Aufbewahrung der Sicherheitsprotokolle fuer 7 Tage festgelegt werden (Empfohlen)? (j/n)"
$confirmation = Read-Host 
if ($confirmation -eq 'j') {
    Write-Host -ForegroundColor Cyan "[INFO] Stelle die Aufbewahrung auf 7 Tage ein"
    Start-Sleep -Seconds 1
    SecurityEventLoggingSize
  
}
    else {Write-Host -ForegroundColor Cyan "[INFO] Die Aufbewahrungszeit wurde NICHT angepasst"
            }

#------------------------------------------------------------------------
# Enable PowerShell logging
#------------------------------------------------------------------------

function PowerShellLogging
{
    [CmdletBinding()]
    param (
        )
    
    Start-Sleep -Seconds 2

    #Wow64 add
    REG ADD HKLM\SOFTWARE\Wow6432Node\Policies\Microsoft\Windows\PowerShell /v EnableScripts /t REG_DWORD /d 1 /f
    REG ADD HKLM\SOFTWARE\Wow6432Node\Policies\Microsoft\Windows\PowerShell /v ExecutionPolicy /t REG_SZ /d RemoteSigned /f

    #Reg add for enabling scripting
    REG ADD HKLM\SOFTWARE\Policies\Microsoft\Windows\PowerShell /v EnableScripts /t REG_DWORD /d 1 /f
    
    Start-Sleep -Seconds 1
    
    #Set rest of settings
    REG ADD HKLM\SOFTWARE\Policies\Microsoft\Windows\PowerShell\ModuleLogging /v EnableModuleLogging /t REG_DWORD /d 1 /f
    REG ADD HKLM\SOFTWARE\Policies\Microsoft\Windows\PowerShell\ScriptBlockLogging /v EnableScriptBlockLogging /t REG_DWORD /d 1 /f
    REG ADD HKLM\SOFTWARE\Policies\Microsoft\Windows\PowerShell\Transcription /v EnableInvocationHeader /t REG_DWORD /d 1 /f
    REG ADD HKLM\SOFTWARE\Policies\Microsoft\Windows\PowerShell\Transcription /v EnableTranscripting /t REG_DWORD /d 1 /f

    }

#------------------------------------------------------------------------
# As user if they would like to enable Powershell logging
#------------------------------------------------------------------------

Write-Host -ForegroundColor Cyan "`n[INFO] Soll das PowerShell-Logging eingeschaltet werden? (j/n)"
$confirmation = Read-Host 
if ($confirmation -eq 'j') {
    Write-Host -ForegroundColor Cyan "[INFO] Konfiguriere das Powershell-Logging"
    Start-Sleep -Seconds 1
    PowerShellLogging
    
}
    else {Write-Host -ForegroundColor Cyan "[INFO] Das Powershell-Logging wurde NICHT angepasst"
            }


#------------------------------------------------------------------------
# PowerShell Transcript Output
#------------------------------------------------------------------------

function PowerShellTranscript
{
    [CmdletBinding()]
    param (
    [Parameter(Mandatory=$True,ValueFromPipeline, HelpMessage = 'Bitte gib einen validen Pfad fuer die PowerShell Transcript Datei an. Beispiel C:\Users\admin\Desktop')]
    [string]$PSTranscriptPath
        )

    $validatebackup = Test-Path $PSTranscriptPath
    Start-Sleep -Seconds 0.5
    If ($validatebackup -eq $true) {
    Write-Host -ForegroundColor Cyan "`n[SUCCESS] $PSTranscriptPath ist ein valider Pfad."
    Write-Host -ForegroundColor Cyan "[INFO] Hinzufügen der Transkriptdateipfadausgabe zum Registrierungsausgabeverzeichnis"
    REG ADD HKLM\SOFTWARE\Policies\Microsoft\Windows\PowerShell\Transcription /v OutputDirectory /t REG_SZ /d $PSTranscriptPath
    }
        else
            {Write-Host -ForegroundColor Cyan "[ERROR] $PSTranscriptPath ist kein valider Pfad, bitte gib einen validen Pfad an. Beispiel: C:\Users\admin\Desktop"}

    }

#------------------------------------------------------------------------
# As user if they would like to enable Powershell logging
#------------------------------------------------------------------------

Write-Host -ForegroundColor Cyan "`n[INFO] Moechtest Du eine Ausgabe des PowerShell Transcripts erstellen? (j/n)"
$confirmation = Read-Host 
if ($confirmation -eq 'j') {
    Write-Host -ForegroundColor Cyan "[INFO] Konfiguriere Powershell Transcript"
    Start-Sleep -Seconds 1
    PowerShellTranscript
    
}
    else {Write-Host -ForegroundColor Cyan "[INFO] Die PowerShellprotokollierung wurde NICHT aktiviert"
            }