﻿<#	
	.NOTES
	===========================================================================
	 Created with: 	Powershell 5
	 Created on:   	29.04.2020 10:43
	 Created by:   	Jörn Walter
	 Organization: 	Der Windows Papst
	 Filename:     	AutoCertRDP.ps1
	===========================================================================
	.DESCRIPTION
		Zertifikat auf Basis einer RDP Vorlage beantragen falls es noch nicht existiert, inkl. IP-Adresse im SAN. Das alte an das RDP_TCP gebundene Zertifikat wird gelöscht.
        In Zeile 51 bestimmen wir, wann das alte Zertifikat durch ein neues ersetzt werden soll. Aktuell, wenn es nur noch 3 Tage gültig ist. Aus Zeile 51 geht auch hervor, wie meine
        Zertifikatsvorlage heißt. In diesem Fall RDPAuth "*Vorlage=RDP*". Unter einem englischen OS "*Template=RDP*"
#>
# Funktion zum Erstellen eines neuen Event-Source
function Test-EventLog {
    Param(
        [Parameter(Mandatory=$true)]
        [string] $LogName
    )

    [System.Diagnostics.EventLog]::SourceExists($LogName)
}

$Event = Test-EventLog "RDPAuth"

If ($Event -eq $false) {

New-EventLog –LogName Application –Source "RDPAuth"

Write-Eventlog -LogName Application -Source "RDPAuth" -EntryType Information -EventId 0 -Message "Die Event-Source RDPAuth wurde angelegt."
}
# Diese Funktion ist eine Erweiterung, um Zertifikate anhand von Templates zu ermitteln.
function Get-Template {
    [OutputType([string])]
    [CmdletBinding()]
    param(
        [Security.Cryptography.X509Certificates.X509Certificate2]$Cert
 )
    Process {
# Die OID bezeichnet die Erweiterung Template. Nicht ändern!
        if (!$template) {
            $template = $Cert.Extensions | ?{$_.Oid.Value -eq "1.3.6.1.4.1.311.21.7"}
        }

        if($template){
            $template.Format(0)
             }
        }
}
# Ist ein vorhandenes Zertifikat basierend auf das Template RDPAuth vorhanden und länger als 3 Tage gültig dann wird hier beendet.
$result = Get-ChildItem "Cert:\LocalMachine\My" | Where-Object {$_.NotAfter -gt (Get-Date).AddDays(3)} | Select-Object @{Name="Template";Expression={Get-Template $_ }} | foreach {$_.template -Like "*Vorlage=RDP*"}

If ($result -eq $True) {

Write-Eventlog -LogName Application -Source "RDPAuth" -EntryType Information -EventId 2 -Message "Ein Zertifikat basierend auf der Vorlage RDPAuth ist vorhanden und noch gültig."

Write-Host "Ein Zertifikat basierend auf der Vorlage SHA256-RDPCertificate ist vorhanden und noch gültig" -ForegroundColor Cyan
Exit
}
# Ist das Ergbnis aber False, dann wird ein neues benantragt. Mit FQDN,DN und der IPv4 Adresse.
else {

$FQDN= $myFQDN=(Get-WmiObject win32_computersystem).DNSHostName+"."+(Get-WmiObject win32_computersystem).Domain

$defaultRouteNic = Get-NetRoute -DestinationPrefix 0.0.0.0/0 | Sort-Object -Property RouteMetric | Select-Object -ExpandProperty ifIndex
$ipv4 = Get-NetIPAddress -AddressFamily IPv4 -InterfaceIndex $defaultRouteNic | Select-Object -ExpandProperty IPAddress

# Die 3 Attribute werden an das Skript Request-Certificate übergeben.
. ($PSScriptRoot + "\Request-Certificate.ps1")  -CN $IPv4 -TemplateName "RDPAuth" -CA "SRVSUBCA.dwp.local\SRVSUBCA" -SAN ("DNS=" + $IPv4 + ",DNS=" + $FQDN + ",DNS=" + $env:COMPUTERNAME) -Country "DE" -City "Essen" -Organisation "DerWindowsPapst" -Department "IT" -FriendlyName "RDPAuth"

Write-Host "Ein Zertifikat basierend auf der Vorlage RDPAuth wurde beantragt" -ForegroundColor Green
Write-Eventlog -LogName Application -Source "RDPAuth" -EntryType Information -EventId 1 -Message "Ein Zertifikat basierend auf der Vorlage RDPAuth wurde beantragt."

 }
# Das aktuelle an das RDP_TCP gebundene Zertifikat wird ermittelt und der Hash (Thumbprint) zwischengespeichert.
$TSSettings = Get-WmiObject -Namespace "root/cimv2/TerminalServices" -Class "Win32_TSGeneralSetting"
$Hash = $TSSettings.SSLCertificateSHA1Hash 
# Das aktuelle nur noch 3 Tage gültige Zertifikat wird gelöscht.
Get-ChildItem Cert:\LocalMachine\My\$Hash -ErrorAction SilentlyContinue | Remove-Item 

Write-Host "Der Hashwert des Zertifikats, gebunden an das RDP_TCP Protkoll lautet $Hash und wird gelöscht" -ForegroundColor Red
Write-Eventlog -LogName Application -Source "RDPAuth" -EntryType Warning -EventId 3 -Message "Der Hashwert des Zertifikats, gebunden an das RDP_TCP Protkoll lautet $Hash und wird gelöscht"
# Das neue Zertifikat welches nun wieder 1 Jahr Laufzeit hat, wird ermittelt und der Thumprint zwischengespeichert.
$FR = Get-ChildItem "Cert:\LocalMachine\My" | Where-Object {$_.Friendlyname -eq "RDPAuth" -and $_.NotAfter -gt (Get-Date).AddDays(364)} | Select Thumbprint
# Prüfung welcher Hash (Thumbprint) aktuell an das Protokoll RDP_TCP gebunden ist.
if (($FR | Measure-Object).Count -gt 0) {
    $OK=$False
    $FR | ForEach-Object {
        if ($_.Thumbprint -eq $Hash) {
            $OK = $True
            Write-Host "Der an das Protokoll RDP_TCP gebundene Hash stimmt mit dem neusten Zertifikat überein." -ForegroundColor Green
            Write-Eventlog -LogName Application -Source "RDPAuth" -EntryType Information -EventId 4 -Message "Der an das Protokoll RDP_TCP gebundene Hash stimmt mit dem neusten Zertifikat überein."
        }
    }
# Ist das nicht der Hash des neuen Zertifikats, was ja sein sollte, wird der alte noch gebundene Hash durch den neuen ersetzt.
    if (-not $OK) {
        $Newthumb=$FR[0].Thumbprint
        wmic /namespace:\\root\cimv2\TerminalServices PATH Win32_TSGeneralSetting Set SSLCertificateSHA1Hash="$newthumb"
        Write-Host "Der an das Protokoll RDP_TCP gebundene Hash wurde von $Hash in $newthumb geändert " -ForegroundColor Red
        Write-Eventlog -LogName Application -Source "RDPAuth" -EntryType Information -EventId 5 -Message "Der an das Protokoll RDP_TCP gebundene Hash wurde von $Hash in $Newthumb geändert."
    }
}
