$report = "C:\Temp\GPOLinkedReporter.csv"

$gpoGuids = Get-GPO -All | Select-Object @{ n='GUID'; e = {$_.Id.ToString()}} | Select-Object -ExpandProperty GUID
$arrAlias = @();
$gpoTotal = $gpoGuids.count
$i=0

foreach ($gpo in $gpoGuids)
{  
   $gpoXML = Get-GPOReport -GUID $($gpo) -ReportType xml
   $results = [xml]$gpoXML
   $totalSOMName = $results.GPO.LinksTo.SOMName.count
   if ( $totalSOMName -gt 1){
       $loop=0
       while ($loop -lt $totalSOMName){
           $objAlias = New-Object psobject   
           Add-Member -InputObject $objAlias -MemberType NoteProperty -Name "Name" -Value $results.gpo.Name 
           Add-Member -InputObject $objAlias -MemberType NoteProperty -Name "SOMName" -Value $results.GPO.LinksTo.SOMName[$loop]
           Add-Member -InputObject $objAlias -MemberType NoteProperty -Name "SOMPATH" -Value $results.GPO.LinksTo.SOMpath[$loop]
           Add-Member -InputObject $objAlias -MemberType NoteProperty -Name "ENABLED" -Value $results.GPO.LinksTo.enabled[$loop]
           $arrAlias += $objAlias
           $loop++
        }
   } else
   {   $objAlias = New-Object psobject
       Add-Member -InputObject $objAlias -MemberType NoteProperty -Name "Name" -Value $results.gpo.Name 
       Add-Member -InputObject $objAlias -MemberType NoteProperty -Name "SOMName" -Value $results.GPO.LinksTo.SOMName
       Add-Member -InputObject $objAlias -MemberType NoteProperty -Name "SOMPATH" -Value $results.GPO.LinksTo.SOMpath
       Add-Member -InputObject $objAlias -MemberType NoteProperty -Name "ENABLED" -Value $results.GPO.LinksTo.enabled
       $arrAlias += $objAlias
       }
}
$arrAlias | Export-Csv $report -Delimiter ';' -NoTypeInformation -Encoding UTF8