﻿# https://www.der-windows-papst.de
# Modul installieren
Install-Module NTFSSecurity -Force #-AllowClobber
Get-Command -Module NTFSSecurity

# Ordner Example und Datei Secure anlegen
New-Item -Path C:\Example -ItemType Directory | Out-Null
"Secure" | Out-File -FilePath C:\Example\Secure.txt
Get-ChildItem -Path C:\Example

# NTFS Rechte abfragen
Get-NTFSAccess -Path C:\Example | Format-Table -AutoSize
Get-NTFSAccess C:\Example\Secure.txt | Format-Table -AutoSize

# Manfred bekommt Vollzugriff auf den Ordner Example
$EX = @{
Path = 'C:\Example'
Account = 'Worker\Manfred'
AccessRights = 'FullControl'
}
Add-NTFSAccess @EX -PassThru

# Manfred werden die Rechte wieder entzogen
$EX = @{
Path = 'C:\Example'
Account = 'Worker\Manfred'
AccessRights = 'FullControl'
}
Remove-NTFSAccess @EX -PassThru

# Vererbung deaktivieren und übergeordnete Rechte entfernen
$EX = @{
Path = 'C:\Example'
RemoveInheritedAccessRules = $True
}
Disable-NTFSAccessInheritance @EX -PassThru

# Manfred bekommt Vollzugriff nur auf den Ordner Example und alle darunter liegenden Daten
$EX = @{
Path = 'C:\Example'
Account = 'Worker\Manfred'
AccessRights = 'FullControl'
}
Add-NTFSAccess @EX -PassThru

# NTFS Rechte abfragen
Get-NTFSAccess -Path C:\Example | Format-Table -AutoSize
Get-NTFSAccess C:\Example\Secure.txt | Format-Table -AutoSize

# Manfred bekommt nur das Recht Lesen auf den Unterordner und alle darunter liegenden Daten
$EX = @{
Path = 'C:\Example\Ordner 2'
Account = 'Worker\Manfred'
AccessRights = 'Read'
}
Add-NTFSAccess @EX -PassThru

# Manfred bekommt das Recht Ändern auf der Testdatei.txt im Unterordner
$EX = @{
Path = 'C:\Example\Ordner 2\Testdatei.txt'
Account = 'Worker\Manfred'
AccessRights = 'Modify'
}
Add-NTFSAccess @EX -PassThru

# Manfred bekommt das Recht Lesen und Ausführen auf der Testdatei.txt im Unterordner
$EX = @{
Path = 'C:\Example\Ordner 2\Testdatei.txt'
Account = 'Worker\Manfred'
AccessRights = 'ReadandExecute'
}
Add-NTFSAccess @EX -PassThru

# Manfred bekommt nur das Recht Berechtigungen ändern auf der Testdatei.txt im Unterordner
$EX = @{
Path = 'C:\Example\Ordner 2\Testdatei.txt'
Account = 'Worker\Manfred'
AccessRights = 'Change'
}
Add-NTFSAccess @EX -PassThru

# Manfred wird nur Owner des Ordners Example
$EX = @{
Path = 'C:\Example'
Account = 'Worker\Manfred'
}
Set-NTFSOwner @EX -PassThru

# Vererbung des Ordners Example wieder aktivieren, die übergeordneten Berechtigungen werden wieder gesetzt
$EX = @{
Path = 'C:\Example'
}
Enable-NTFSAccessInheritance @EX -PassThru

# Zeige welche Berechtigungen manuell gesetzt worden sind aber keine vererbten Berechtigungen
Dir 'C:\Example' | Get-NTFSAccess –ExcludeInherite

# Alle Berechtigungen auf dem Ordner entfernen bis auf die vererbten
$EX = @{
Path = 'C:\Example'
}
Clear-NTFSAccess @EX

# Alle Berechtigungen die manuell gesetzt worden sind rekursiv auf dem Ordner entfernen bis auf die vererbten
Get-ChildItem -Path 'C:\Example' -Recurse -Force | Clear-NTFSAccess

# Zeige effektive NTFS Berechtigungen auf Ordner eines bestimmten Users an
Get-ChildItem -Path 'C:\Example' -Recurse -Directory | Get-NTFSEffectiveAccess -Account 'Worker\Manfred’ | select Account, AccessControlType, AccessRights, FullName

# Zeige effektive Berechtigungen einer Datei an
Get-Item -Path 'C:\Example\Secure.txt' | Get-NTFSEffectiveAccess -Account 'Worker\Manfred’ | Format-List

# Bericht eines Ordners erstellen rekursiv

$FolderPath = Get-ChildItem -Directory -Path "C:\Temp" -Recurse -Force
$Output = @()
ForEach ($Folder in $FolderPath) {
$Acl = Get-Acl -Path $Folder.FullName
ForEach ($Access in $Acl.Access) {
$Properties = [ordered]@{'Folder Name'=$Folder.FullName;'Group/User'=$Access.IdentityReference;'Permissions'=$Access.FileSystemRights;'Inherited'=$Access.IsInherited}
$Output += New-Object -TypeName PSObject -Property $Properties
}
}
$Output | Export-csv -Path "D:\Report.csv" -Encoding UTF8

# Owner ändern und einer Gruppe Vollzugriff auf Dateien gewähren

$AL = Get-Content "C:\Temp\AccessList.txt"
foreach ($i in $AL)
{
If(Test-Path $i)
{
Write-Host "Ändere den Owner des Ordners $i" -Foreground Green
Get-Item $i | Set-NTFSOwner -Account 'dwp.local\JW'
Get-Item $i | Add-NTFSAccess -Account 'dwp.local\JW' -AccessRights FullControl
Get-Item $i | Add-NTFSAccess -Account 'NT AUTHORITY\System' -AccessRights FullControl

$items = @()
$items = $null
$path = $null
$items = Get-Childitem $i -recurse -force
foreach($item in $items)
{
$path = $item.FullName
Write-Host "Die Gruppe File-Admins bekommt Vollzugriff auf $path" -Foreground Green
Get-Item -force $path | Set-NTFSOwner -Account 'dwp.local\FileAdmin'
Get-Item -force $path | Add-NTFSAccess -Account 'dwp.local\FileAdmin' -AccessRights FullControl
}
}
}

# Ausgabe der Syntax des Moduls NTFSSecurity

Get-Command -Module NTFSSecurity -CommandType Cmdlet -Syntax | Out-GridView
