## Pfad zur Url Liste
$URLListFile = "c:\PowerShell\URLList.txt"   
$URLList = Get-Content $URLListFile -ErrorAction SilentlyContinue 
  $Result1 = @() 
  $booltime = 0
 
## Variablen bestimmen
  Foreach ($Uri in $URLList) { 
  $time = try{ 
  $request = $null 
  
## Urls ansprechen und Antwortzeiten ermitteln
  $result2 = Measure-Command { $request = Invoke-WebRequest -Uri $uri -UseDefaultCredentials -UseBasicParsing } 
  $result2.Totalseconds 
  $ResultsTime = $result2.TotalSeconds
  if($ResultsTime -gt 0)
    {
    write-host $uri, $ResultsTime
    $booltime++
    write-host $booltime
    }
  }  
  catch 
  { 

## Wenn die Anforderung eine Ausnahme 500 oder 404 zurckgibt wird der Status-Code ermittelt 
   $request = $_.Exception.Response 
   $time = -1 
  }   
  $result1 += [PSCustomObject] @{ 
  Time = Get-Date; 
  Uri = $uri; 
  StatusCode = [int] $request.StatusCode; 
  StatusDescription = $request.StatusDescription; 
  ResponseLength = $request.RawContentLength; 
  TimeTaken =  $time;  
  } 
 
} 

## Ausgabe in HTML wird aufgebaut

if($booltime -gt 0 )
{

if($result1 -ne $null) 
{ 
    $Outputreport = "<HTML><TITLE>Websiten Status ermitteln</TITLE><BODY background-color:peachpuff><font color =""#99000"" face=""Microsoft Table""><H2> Webseiten Status </H2></font><Table border=1 cellpadding=0 cellspacing=0><TR bgcolor=gray align=center><TD><B>URL</B></TD><TD><B>StatusCode</B></TD><TD><B>StatusDescription</B></TD><TD><B>ResponseLength</B></TD><TD><B>TimeTaken</B></TD</TR>" 
    Foreach($Entry in $Result1) 
    { 
        if($Entry.StatusCode -ne "200") 
        { 
            $Outputreport += "<TR bgcolor=red>" 
        } 
        else 
        { 
            $Outputreport += "<TR bgcolor=green>" 
        } 
        $Outputreport += "<TD>$($Entry.uri)</TD><TD align=center>$($Entry.StatusCode)</TD><TD align=center>$($Entry.StatusDescription)</TD><TD align=center>$($Entry.ResponseLength)</TD><TD align=center>$($Entry.timetaken)</TD></TR>" 
    } 
    $Outputreport += "</Table></BODY></HTML>" 
} 
$Filename = "C:\PowerShell\URLCheck-" + [DateTime]::Now.ToString("dd-MM-yyyy-HH-mm-ss") + ".htm"
$Outputreport | out-file $Filename

## Ausgabe ffnen
Invoke-Item $Filename

}