Clear
function GPOSearch ($Str) {

$Str = Read-Host -Prompt "Suche in GPOs nach?"
$Domain = $env:USERDNSDOMAIN

write-host "Folgende GPOs sind in $Domain vorhanden und werden durchsucht" -ForegroundColor Gray

$GPOs = Get-GPO -All -Domain $Domain

Write-Host "Starte die Suche nach $Str"

foreach ($GPO in $GPOs) {
    $report = Get-GPOReport -Guid $GPO.Id -ReportType Xml
    if ($Report -match $Str) {
        write-host "$Str gefunden in $($GPO.DisplayName)" -ForegroundColor Green
    }
    else {
        Write-Host "Nicht vorhanden in der Richtlinie: $($GPO.DisplayName)" -ForegroundColor Red
    }
}
}