###################################
# SPN-Manager
# V1.0 20.02.2019 AK
# bulletproof-admin.de
###################################

# Module
# import-module ActiveDirectory

# Varialblen
$tempfile = $env:TEMP+"\spn.txt"

Remove-Item -Path $tempfile -Force -ErrorAction SilentlyContinue
cls
Write-Host "Mit diesem Tool knnen SPNs eines Users oder Computers ausgelesen und bei Bedarf gelscht werden..." -ForegroundColor Green
Write-Host "Bitte Objekt auswhlen..."

# AD Picker https://gallery.technet.microsoft.com/scriptcenter/Active-Directory-Object-a832f7bd

Add-Type -Path (Join-Path -Path (Split-Path $script:MyInvocation.MyCommand.Path) -ChildPath 'bin\CubicOrange.Windows.Forms.ActiveDirectory.dll')

$DialogPicker = New-Object CubicOrange.Windows.Forms.ActiveDirectory.DirectoryObjectPickerDialog

$DialogPicker.AllowedLocations = [CubicOrange.Windows.Forms.ActiveDirectory.Locations]::All
$DialogPicker.AllowedObjectTypes = [CubicOrange.Windows.Forms.ActiveDirectory.ObjectTypes]::Groups,[CubicOrange.Windows.Forms.ActiveDirectory.ObjectTypes]::Users,[CubicOrange.Windows.Forms.ActiveDirectory.ObjectTypes]::Computers
$DialogPicker.DefaultLocations = [CubicOrange.Windows.Forms.ActiveDirectory.Locations]::JoinedDomain
$DialogPicker.DefaultObjectTypes = [CubicOrange.Windows.Forms.ActiveDirectory.ObjectTypes]::Users
$DialogPicker.ShowAdvancedView = $false
$DialogPicker.MultiSelect = $true
$DialogPicker.SkipDomainControllerCheck = $true
$DialogPicker.Providers = [CubicOrange.Windows.Forms.ActiveDirectory.ADsPathsProviders]::Default

$DialogPicker.AttributesToFetch.Add('samAccountName')
$DialogPicker.AttributesToFetch.Add('title')
$DialogPicker.AttributesToFetch.Add('department')
$DialogPicker.AttributesToFetch.Add('distinguishedName')

# AUswhlen, auf welches Object angewendet wird..

$DialogPicker.ShowDialog()


# Computer oder User?
$typ = $DialogPicker.SelectedObject.SchemaClassName

# Anmeldename
$account=  $DialogPicker.Selectedobject.FetchedAttributes[0]
$account =  $env:USERDOMAIN + "\"+$account

if (-not($account))
    {
    Write-Host "Keine Auswahl. Ende." -ForegroundColor Red
    exit
    }

Write-Host "Einlesen der Daten..." -ForegroundColor Green

Start-Process -filepath "setspn.exe" -ArgumentList ("-L "+$account) -RedirectStandardOutput $tempfile -NoNewWindow -Wait

$spn_list = Get-Content -Path $tempfile -ErrorAction SilentlyContinue
if (-not($spn_list))
{
    Write-Host "Keine SPNs fr "$account "Registriert. Abbruch" -ForegroundColor Red
    exit
    }

if ($spn_list -isnot [system.array])
    {
    Write-Host "Keine SPNs fr "$account "Registriert. Abbruch" -ForegroundColor Red
    exit
    }


# Erste Zeile lschen
$spn_list = $spn_list[1..($spn_list.Length-1)]
# Trimmen
$spn_list = $spn_list | ForEach-Object {($_).ToString().Trim()}

$anz = $spn_list.Count

# Ausgabe
$erg = $spn_list | Out-GridView -Title ("Bitte zu lschende SPNs whlen fr "+$account) -OutputMode Multiple
if ($erg)
    {
    $count = 1
    $anz = $erg.Count
    foreach ($spn in $erg)
    {
    Write-Host "*****************************************************"
    Write-Host $count "von" $anz $spn
    $command = ' -D "'+$spn.trim()+'" "'+$account+'"'
    start setspn.exe -ArgumentList $command -NoNewWindow
    Start-Sleep -Seconds 1
    $count++
    }

    }
    else
    {
    Write-Host "Keine Auswahl bzw. Abbruch" -ForegroundColor Red
    }


# Fertig
Remove-Item -Path $tempfile -Force -ErrorAction SilentlyContinue